package com.agilex.healthcare.veteranappointment.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.agilex.healthcare.veteranappointment.datalayer.appointment.ProviderPo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.LinkedList;
import java.util.ArrayList;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "ccAppointmentRequest", namespace = Namespace.VeteranAppointmentRequest)
@JsonAutoDetect
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CCAppointmentRequest extends VARAppointmentRequest {
    private static final long serialVersionUID = -613294957626640127L;

    @XmlElement
    private Boolean travelBurden;

    @XmlElement
    private Boolean unusualTravelBurden;

    @XmlElement
    private String address;

    @XmlElement
    private String city;

    @XmlElement
    private String state;

    @XmlElement
    private String zipCode;

    @XmlElement
    private String preferredZipCode;

    @XmlElement
    private String preferredState;

    @XmlElement
    private String preferredCity;

    @XmlElement
    private String preferredLanguage;

    @XmlElement
    private int distanceWillingToTravel;

    @XmlElement
    private boolean distanceEligible;

    @XmlElement
    private Set<String> officeHours = new HashSet<String>();

    @XmlElement
    private List<Provider> preferredProviders = new ArrayList<Provider>();

    public Boolean getTravelBurden() {
        return travelBurden;
    }

    public void setTravelBurden(Boolean travelBurden) {
        this.travelBurden = travelBurden;
    }

    public Boolean getUnusualTravelBurden() {
        return unusualTravelBurden;
    }

    public void setUnusualTravelBurden(Boolean unusualTravelBurden) {
        this.unusualTravelBurden = unusualTravelBurden;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getPreferredZipCode() {
        return preferredZipCode;
    }

    public void setPreferredZipCode(String preferredZipCode) {
        this.preferredZipCode = preferredZipCode;
    }

    public int getDistanceWillingToTravel() {
        return this.distanceWillingToTravel;
    }

    public void setDistanceWillingToTravel(int distanceWillingToTravel) {
        this.distanceWillingToTravel = distanceWillingToTravel;
    }

    public boolean getDistanceEligible() {
        return distanceEligible;
    }

    public void setDistanceEligible(boolean distanceEligible) {
        this.distanceEligible = distanceEligible;
    }

    public String getPreferredState() {
        return preferredState;
    }

    public void setPreferredState(String preferredState) {
        this.preferredState = preferredState;
    }

    public String getPreferredCity() {
        return preferredCity;
    }

    public void setPreferredCity(String preferredCity) {
        this.preferredCity = preferredCity;
    }

    public String getPreferredLanguage() {
        return preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public Set<String> getOfficeHours() {
        return officeHours;
    }

    public void setOfficeHours(Set<String> officeHours) {
        this.officeHours = officeHours;
    }

    public List<Provider> getPreferredProviders() {
        return preferredProviders;
    }

    public void setPreferredProviders(List<Provider> preferredProviders) {
        this.preferredProviders = preferredProviders;
    }
}